// Simple lerp example

float4x4 wvp   : WorldViewProjection;

texture baseTexture1 < string ResourceName = ""; >;
texture baseTexture2 < string ResourceName = ""; >;
texture maskTexture < string ResourceName = ""; >;

sampler2D   baseSample1 = sampler_state 
{ texture = <baseTexture1>;
  mipFilter = linear;
  magFilter = linear;
  minFilter = linear;
  addressU = wrap;
  addressV = wrap;
};

sampler2D   baseSample2 = sampler_state 
{ texture = <baseTexture2>;
  mipFilter = linear;
  magFilter = linear;
  minFilter = linear;
  addressU = wrap;
  addressV = wrap;
};

sampler2D   maskSample = sampler_state 
{ texture = <maskTexture>;
  mipFilter = linear;
  magFilter = linear;
  minFilter = linear;
  addressU = wrap;
  addressV = wrap;
};

struct VSInput
{ float4 pos   : position;
  float2 UV    : texcoord0;
};

struct VSOutput
{ float4 pos   : position;
  float2 UV    : texcoord0;
};

struct PSInput
{ float2 UV : texcoord0;
};

struct PSOutput {  float4 col : Color; };

VSOutput VShader(VSInput In, VSOutput Out)
{ Out.pos = mul(In.pos, wvp);
  Out.UV = In.UV;
  return Out;
}

PSOutput PShader(PSInput In, PSOutput Out)
{ Out.col = lerp(tex2D(baseSample1, In.UV),
                 tex2D(baseSample2, In.UV),
                 tex2D(maskSample, In.UV));
  return Out;
}

technique test
{  pass p0
   {  vertexShader = compile vs_2_0 VShader();
      pixelShader  = compile ps_2_0 PShader();
   }
}
